<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
<#assign httpPort = "8080">
<#assign nacosUrl = "172.16.102.211:8848" >
<#if sysrun?? >
<#if sysrun.getPSDevSlnMSDepAPI()??>
    <#--  微服务部署API  -->
    <#if sysrun.getPSDevSlnMSDepAPI().getHttpPort()??>
      <#assign httpPort = sysrun.getPSDevSlnMSDepAPI().getHttpPort()?c>
    </#if>
    <#if sysrun.getPSDevSlnMSDepAPI().getPSDCMSPlatformNode().getPSDCMSPlatform().getUserParam("nacos","172.16.102.211:8848")??>
        <#assign nacosUrl = sysrun.getPSDevSlnMSDepAPI().getPSDCMSPlatformNode().getPSDCMSPlatform().getUserParam("nacos","172.16.102.211:8848")>
      </#if>
  </#if>
</#if>
server:
  port: ${httpPort}

spring:
  application:
    name: ${item.getCodeName()?lower_case}
  cloud:
    <#--  后期需要修改为节点获取  -->
    nacos:
      discovery:
        server-addr: ${nacosUrl}
<#if sysrun.getPSDBDevInst()??>
  <#assign dbinst = sysrun.getPSDBDevInst()>
  datasource:
    password: '${dbinst.getPassword()}'
    username: ${dbinst.getUserName()}
    url: ${dbinst.getConnUrl()}
    driver-class-name: <#if (dbinst.getDBType()=='MYSQL5')>com.mysql.jdbc.Driver<#elseif (dbinst.getDBType()=='DB2')>com.ibm.db2.jcc.DB2Driver<#elseif (dbinst.getDBType()=='ORACLE')>oracle.jdbc.driver.OracleDriver<#elseif (dbinst.getDBType()=='SQLSERVER')>com.microsoft.sqlserver.jdbc.SQLServerDriver<#elseif (dbinst.getDBType()=='POSTGRESQL')>org.postgresql.Driver<#elseif (dbinst.getDBType()=='PPAS')>com.edb.Driver</#if>
    filters: stat,wall,log4j2
    #配置初始化大小/最小/最大
    initial-size: 1
    min-idle: 1
    max-active: 20
    #获取连接等待超时时间
    max-wait: 60000
    #间隔多久进行一次检测，检测需要关闭的空闲连接
    time-between-eviction-runs-millis: 60000
    #一个连接在池中最小生存的时间
    min-evictable-idle-time-millis: 300000
    validation-query: SELECT 1 FROM DUAL
    test-while-idle: true
    test-on-borrow: false
    test-on-return: false
    #打开PSCache，并指定每个连接上PSCache的大小。oracle设为true，mysql设为false。分库分表较多推荐设置为false
    pool-prepared-statements: false
    max-pool-prepared-statement-per-connection-size: 20
</#if>

feign:
  sentinel:
    enabled: true

# Logger Config
logging:
  level:
    ${pub.getPKGCodeName()}: debug

<#if sys.getAllPSSubSysServiceAPIs()??>
client:
  service:
  <#list sys.getAllPSSubSysServiceAPIs() as subsysapi>
    ${subsysapi.getCodeName()?lower_case}:
      service-id: ${subsysapi.getServiceCodeName()?lower_case}
  </#list>
</#if>

<#if (sys.getAllPSWorkflows()?? && srflist(sys.getAllPSWorkflows())?size gt 0) || pub.getUserTag() != "IBIZUNIWF">
    <#assign wfrootpath = "">
    <#if sys.getAllPSSysServiceAPIs()??>
        <#list sys.getAllPSSysServiceAPIs() as sysapi>
            <#if sysapi.getUserTag() == "WFSERVICE">
                <#assign wfrootpath = sysapi.getCodeName()?lower_case>
            </#if>
        </#list>
    </#if>
ibiz:
  wfrootpath: ${wfrootpath}
</#if>

